<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require_once 'config.php';
$conn = getDBConnection();

$pools_result = $conn->query("SELECT COUNT(DISTINCT pool_number) as count FROM pools");
$pools_count = $pools_result->fetch_assoc()['count'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="admin.php">Dashboard</a>
            <a href="admin_setup.php">Tournament Setup</a>
            <a href="admin_matches.php">Generate Matches</a>
            <a href="admin_manage_matches.php">Manage Matches</a>
            <a href="admin_knockout.php">Knockout Setup</a>
            <a href="logout.php">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Admin Dashboard</h1>
        
        <?php if (isset($_SESSION['reset_success'])): ?>
            <div class="alert alert-success">
                <?php 
                echo $_SESSION['reset_success']; 
                unset($_SESSION['reset_success']);
                ?>
            </div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['reset_error'])): ?>
            <div class="alert alert-error">
                <?php 
                echo $_SESSION['reset_error']; 
                unset($_SESSION['reset_error']);
                ?>
            </div>
        <?php endif; ?>
        
        <div class="form-card">
            <h2>Tournament Overview</h2>
            <p><strong>Total Pools Created:</strong> <?php echo $pools_count; ?></p>
            
            <?php
            $teams_query = "SELECT p.pool_number, COUNT(t.id) as team_count 
                           FROM pools p 
                           LEFT JOIN teams t ON p.id = t.pool_id 
                           GROUP BY p.pool_number 
                           ORDER BY p.pool_number";
            $teams_result = $conn->query($teams_query);
            
            if ($teams_result->num_rows > 0) {
                echo "<h3 style='margin-top: 20px;'>Pool Details</h3>";
                echo "<table style='width: 100%; margin-top: 10px;'>";
                echo "<tr style='background: #34495e; color: white;'>
                        <th style='padding: 10px;'>Pool</th>
                        <th style='padding: 10px;'>Teams</th>
                        <th style='padding: 10px;'>Referees</th>
                      </tr>";
                
                while ($row = $teams_result->fetch_assoc()) {
                    $pool_num = $row['pool_number'];
                    $ref_query = "SELECT COUNT(r.id) as ref_count 
                                 FROM referees r 
                                 JOIN pools p ON p.id = r.pool_id 
                                 WHERE p.pool_number = $pool_num";
                    $ref_result = $conn->query($ref_query);
                    $ref_count = $ref_result->fetch_assoc()['ref_count'];
                    
                    echo "<tr style='border-bottom: 1px solid #ddd;'>
                            <td style='padding: 10px;'>Pool " . $row['pool_number'] . "</td>
                            <td style='padding: 10px;'>" . $row['team_count'] . "</td>
                            <td style='padding: 10px;'>" . $ref_count . "</td>
                          </tr>";
                }
                echo "</table>";
            }
            ?>
        </div>
        
        <div class="form-card">
            <h2>Quick Actions</h2>
            <div class="button-group">
                <a href="admin_setup.php" class="btn btn-primary">Setup Tournament</a>
                <a href="admin_matches.php" class="btn btn-success">Generate Matches</a>
                <a href="admin_manage_matches.php" class="btn btn-warning">Manage Matches</a>
                <a href="admin_knockout.php" class="btn btn-warning">Knockout Setup</a>
                <a href="spectator.php" class="btn btn-secondary">View Scoreboard</a>
            </div>
        </div>
        
        <div class="form-card" style="border-left: 4px solid #e74c3c;">
            <h2 style="color: #e74c3c;">WARNING</h2>
            <p style="margin-bottom: 15px;">Delete all matches completely. Spectators will see an empty tournament. Teams and structure will remain.</p>
            <form method="POST" action="admin_reset.php" onsubmit="return confirm('WARNING: This will DELETE all matches completely!\n\nSpectators will see nothing.\nYou will need to regenerate matches.\n\nAre you absolutely sure?');">
                <button type="submit" name="reset_matches" class="btn btn-danger">
                    Delete All Matches
                </button>
            </form>
        </div>
    </div>
</body>
</html>
<?php $conn->close(); ?>