<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require_once 'config.php';
$conn = getDBConnection();
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_match'])) {
    $match_id = intval($_POST['match_id']);
    $team1_id = intval($_POST['team1_id']);
    $team2_id = intval($_POST['team2_id']);
    $pool_id = intval($_POST['pool_id']);
    $referee_name = trim($_POST['referee_name']);
    $court_name = trim($_POST['court_name']);
    $start_time = trim($_POST['start_time']);
    
    if ($team1_id == $team2_id) {
        $message = "Error: Teams must be different!";
    } else {
        $referee_id = null;
        if (!empty($referee_name)) {
            $ref_check = $conn->query("SELECT id FROM referees WHERE name = '" . $conn->real_escape_string($referee_name) . "' AND pool_id = $pool_id");
            
            if ($ref_check && $ref_check->num_rows > 0) {
                $referee_id = $ref_check->fetch_assoc()['id'];
            } else {
                $ref_insert = $conn->query("INSERT INTO referees (name, pool_id) VALUES ('" . $conn->real_escape_string($referee_name) . "', $pool_id)");
                if ($ref_insert) {
                    $referee_id = $conn->insert_id;
                }
            }
        }
        
        if ($referee_id) {
            $update_query = "UPDATE matches SET team1_id = ?, team2_id = ?, referee_id = ?, court_name = ?, start_time = ? WHERE id = ?";
            $stmt = $conn->prepare($update_query);
            if ($stmt) {
                $stmt->bind_param("iiissi", $team1_id, $team2_id, $referee_id, $court_name, $start_time, $match_id);
                if ($stmt->execute()) {
                    $message = "Match updated successfully!";
                } else {
                    $message = "Error updating match: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $message = "Error preparing statement: " . $conn->error;
            }
        } else {
            $update_query = "UPDATE matches SET team1_id = ?, team2_id = ?, referee_id = NULL, court_name = ?, start_time = ? WHERE id = ?";
            $stmt = $conn->prepare($update_query);
            if ($stmt) {
                $stmt->bind_param("iissi", $team1_id, $team2_id, $court_name, $start_time, $match_id);
                if ($stmt->execute()) {
                    $message = "Match updated successfully!";
                } else {
                    $message = "Error updating match: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $message = "Error preparing statement: " . $conn->error;
            }
        }
    }
}

$pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Matches</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="admin.php">Dashboard</a>
            <a href="admin_setup.php">Tournament Setup</a>
            <a href="admin_matches.php">Generate Matches</a>
            <a href="admin_manage_matches.php">Manage Matches</a>
            <a href="admin_knockout.php">Knockout Setup</a>
            <a href="logout.php">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Manage Round Robin Matches</h1>
        
        <?php if ($message): ?>
            <div class="alert <?php echo strpos($message, 'Error') !== false ? 'alert-error' : 'alert-success'; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>
        
        <div class="form-card">
            <p style="color: #7f8c8d; margin-bottom: 20px;">
                Edit match details including teams, referees, courts, and start times. Modify fields and click "Save Changes" for each match.
            </p>
        </div>
        
        <?php
        $pools_result->data_seek(0);
        while ($pool = $pools_result->fetch_assoc()):
            $pool_id = $pool['id'];
            
            $teams_query = "SELECT * FROM teams WHERE pool_id = $pool_id ORDER BY name";
            $teams_result = $conn->query($teams_query);
            $pool_teams = [];
            while ($team = $teams_result->fetch_assoc()) {
                $pool_teams[] = $team;
            }
            
            $matches_query = "SELECT m.*, 
                                     t1.name AS team1_name, 
                                     t2.name AS team2_name, 
                                     r.name AS referee_name 
                              FROM matches m 
                              JOIN teams t1 ON m.team1_id = t1.id 
                              JOIN teams t2 ON m.team2_id = t2.id 
                              LEFT JOIN referees r ON m.referee_id = r.id 
                              WHERE m.pool_id = $pool_id AND m.match_type = 'round_robin'
                              ORDER BY m.round_number";
            $matches_result = $conn->query($matches_query);
            
            if ($matches_result && $matches_result->num_rows > 0):
        ?>
        <div class="form-card">
            <h2>Pool <?php echo $pool['pool_number']; ?> - Edit Matches</h2>
            
            <?php while ($match = $matches_result->fetch_assoc()): ?>
            <div style="background: #f8f9fa; padding: 20px; margin-bottom: 15px; border-radius: 8px; border-left: 4px solid #3498db;">
                <h3>Round <?php echo $match['round_number']; ?></h3>
                <form method="POST" style="margin-top: 15px;">
                    <input type="hidden" name="match_id" value="<?php echo $match['id']; ?>">
                    <input type="hidden" name="pool_id" value="<?php echo $pool_id; ?>">
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                        <div class="form-group">
                            <label>Team 1</label>
                            <select name="team1_id" class="form-control" required>
                                <?php foreach ($pool_teams as $team): ?>
                                <option value="<?php echo $team['id']; ?>" <?php echo $match['team1_id'] == $team['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($team['name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Team 2</label>
                            <select name="team2_id" class="form-control" required>
                                <?php foreach ($pool_teams as $team): ?>
                                <option value="<?php echo $team['id']; ?>" <?php echo $match['team2_id'] == $team['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($team['name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Referee Name</label>
                            <input type="text" name="referee_name" class="form-control" value="<?php echo htmlspecialchars($match['referee_name'] ?? ''); ?>" placeholder="Enter referee name">
                        </div>
                        
                        <div class="form-group">
                            <label>Court</label>
                            <input type="text" name="court_name" class="form-control" value="<?php echo htmlspecialchars($match['court_name'] ?? ''); ?>" placeholder="e.g., Court 1">
                        </div>
                        
                        <div class="form-group">
                            <label>Start Time</label>
                            <input type="text" name="start_time" class="form-control" value="<?php echo htmlspecialchars($match['start_time'] ?? ''); ?>" placeholder="e.g., 09:00 AM - 09:30 AM">
                        </div>
                    </div>
                    
                    <div style="margin-top: 10px;">
                        <button type="submit" name="update_match" class="btn btn-success" style="padding: 8px 20px;">
                            Save Changes
                        </button>
                        <span style="margin-left: 15px; color: #7f8c8d;">
                            Status: <strong><?php echo str_replace('_', ' ', ucfirst($match['status'])); ?></strong> | 
                            Score: <?php echo $match['team1_score']; ?> - <?php echo $match['team2_score']; ?>
                        </span>
                    </div>
                </form>
            </div>
            <?php endwhile; ?>
        </div>
        <?php 
            endif;
        endwhile;
        ?>
        
        <?php
        $knockout_query = "SELECT m.*, 
                                  t1.name AS team1_name, 
                                  t2.name AS team2_name, 
                                  r.name AS referee_name 
                           FROM matches m 
                           JOIN teams t1 ON m.team1_id = t1.id 
                           JOIN teams t2 ON m.team2_id = t2.id 
                           LEFT JOIN referees r ON m.referee_id = r.id 
                           WHERE m.match_type = 'knockout'
                           ORDER BY m.round_number, m.id";
        $knockout_result = $conn->query($knockout_query);
        
        if ($knockout_result && $knockout_result->num_rows > 0):
            $all_teams_query = "SELECT * FROM teams ORDER BY name";
            $all_teams_result = $conn->query($all_teams_query);
            $all_teams = [];
            while ($team = $all_teams_result->fetch_assoc()) {
                $all_teams[] = $team;
            }
        ?>
        <div class="form-card">
            <h2>Knockout Matches - Edit</h2>
            
            <?php while ($match = $knockout_result->fetch_assoc()): ?>
            <div style="background: #fef9e7; padding: 20px; margin-bottom: 15px; border-radius: 8px; border-left: 4px solid #f39c12;">
                <h3>Round <?php echo $match['round_number']; ?> - Knockout</h3>
                <form method="POST" style="margin-top: 15px;">
                    <input type="hidden" name="match_id" value="<?php echo $match['id']; ?>">
                    <input type="hidden" name="pool_id" value="1">
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                        <div class="form-group">
                            <label>Team 1</label>
                            <select name="team1_id" class="form-control" required>
                                <?php foreach ($all_teams as $team): ?>
                                <option value="<?php echo $team['id']; ?>" <?php echo $match['team1_id'] == $team['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($team['name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Team 2</label>
                            <select name="team2_id" class="form-control" required>
                                <?php foreach ($all_teams as $team): ?>
                                <option value="<?php echo $team['id']; ?>" <?php echo $match['team2_id'] == $team['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($team['name']); ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Referee Name</label>
                            <input type="text" name="referee_name" class="form-control" value="<?php echo htmlspecialchars($match['referee_name'] ?? ''); ?>" placeholder="Enter referee name">
                        </div>
                        
                        <div class="form-group">
                            <label>Court</label>
                            <input type="text" name="court_name" class="form-control" value="<?php echo htmlspecialchars($match['court_name'] ?? ''); ?>" placeholder="e.g., Court 1">
                        </div>
                        
                        <div class="form-group">
                            <label>Start Time</label>
                            <input type="text" name="start_time" class="form-control" value="<?php echo htmlspecialchars($match['start_time'] ?? ''); ?>" placeholder="e.g., 09:00 AM - 09:30 AM">
                        </div>
                    </div>
                    
                    <div style="margin-top: 10px;">
                        <button type="submit" name="update_match" class="btn btn-success" style="padding: 8px 20px;">
                            Save Changes
                        </button>
                        <span style="margin-left: 15px; color: #7f8c8d;">
                            Status: <strong><?php echo str_replace('_', ' ', ucfirst($match['status'])); ?></strong> | 
                            Score: <?php echo $match['team1_score']; ?> - <?php echo $match['team2_score']; ?>
                        </span>
                    </div>
                </form>
            </div>
            <?php endwhile; ?>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
<?php $conn->close(); ?>