<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require_once 'config.php';
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['generate_matches'])) {
    $conn = getDBConnection();

    $conn->query("DELETE FROM matches");

    $pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");

    while ($pool = $pools_result->fetch_assoc()) {
        $pool_id = $pool['id'];

        $teams_result = $conn->query("SELECT * FROM teams WHERE pool_id = $pool_id");
        $teams = [];
        while ($team = $teams_result->fetch_assoc()) {
            $teams[] = $team;
        }

        $refs_result = $conn->query("SELECT * FROM referees WHERE pool_id = $pool_id");
        $referees = [];
        while ($ref = $refs_result->fetch_assoc()) {
            $referees[] = $ref;
        }

        $num_teams = count($teams);

        if ($num_teams < 2) continue; 

        $has_bye = false;
        if ($num_teams % 2 !== 0) {
            $teams[] = ['id' => 0, 'name' => 'BYE'];
            $num_teams++;
            $has_bye = true;
        }

        $num_rounds = $num_teams - 1;
        $matches_per_round = $num_teams / 2;

        $all_matches = [];
        $match_counter = 1;
        
        for ($round = 0; $round < $num_rounds; $round++) {
            for ($i = 0; $i < $matches_per_round; $i++) {
                $team1 = $teams[$i];
                $team2 = $teams[$num_teams - 1 - $i];

                if (!isset($team1['id']) || !isset($team2['id'])) continue;
                if ($team1['id'] == 0 || $team2['id'] == 0) continue;

                $all_matches[] = [
                    'round' => $match_counter,
                    'team1_id' => $team1['id'],
                    'team2_id' => $team2['id']
                ];
                
                $match_counter++;
            }

            $fixed = $teams[0];
            $rotating = array_slice($teams, 1);
            $last = array_pop($rotating);
            array_unshift($rotating, $last);
            $teams = array_merge([$fixed], $rotating);
        }

        $ref_index = 0;
        foreach ($all_matches as $match) {
            $referee_id = count($referees) > 0 ? $referees[$ref_index % count($referees)]['id'] : "NULL";

            $conn->query("INSERT INTO matches (pool_id, round_number, team1_id, team2_id, referee_id, match_type) 
                          VALUES ($pool_id, {$match['round']}, {$match['team1_id']}, {$match['team2_id']}, 
                          " . ($referee_id ?: "NULL") . ", 'round_robin')");

            $ref_index++;
        }
    }

    $message = "Round robin matches generated with balanced scheduling!";
}

$conn = getDBConnection();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Matches</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="admin.php">Dashboard</a>
            <a href="admin_setup.php">Tournament Setup</a>
            <a href="admin_matches.php">Generate Matches</a>
            <a href="admin_knockout.php">Knockout Setup</a>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <h1>Generate Matches</h1>

        <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
        <?php endif; ?>

        <div class="form-card">
            <h2>Generate Round Robin Matches</h2>
            <form method="POST" style="display: inline-block; margin-right: 10px;">
                <button type="submit" name="generate_matches" class="btn btn-success"
                        onclick="return confirm('This will delete existing matches and create new ones. Continue?')">
                    Generate Round Robin Matches
                </button>
            </form>
            <form method="POST" action="admin_reset.php" style="display: inline-block;">
                <button type="submit" name="reset_matches" class="btn btn-danger"
                        onclick="return confirm('WARNING: This will DELETE all matches!\n\nSpectators will see an empty tournament.\n\nAre you sure?')">
                    Delete All Matches
                </button>
            </form>
        </div>

        <?php
        $pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");
        while ($pool = $pools_result->fetch_assoc()):
            $pool_id = $pool['id'];
            $matches_query = "SELECT m.*, 
                                     t1.name AS team1_name, 
                                     t2.name AS team2_name, 
                                     r.name AS referee_name 
                              FROM matches m 
                              JOIN teams t1 ON m.team1_id = t1.id 
                              JOIN teams t2 ON m.team2_id = t2.id 
                              LEFT JOIN referees r ON m.referee_id = r.id 
                              WHERE m.pool_id = $pool_id AND m.match_type = 'round_robin'
                              ORDER BY m.round_number";
            $matches_result = $conn->query($matches_query);

            if ($matches_result->num_rows > 0):
        ?>
        <div class="form-card">
            <h2>Pool <?php echo $pool['pool_number']; ?> - Matches</h2>
            <div class="match-table">
                <table>
                    <thead>
                        <tr>
                            <th>Round</th>
                            <th>Team 1</th>
                            <th>Team 2</th>
                            <th>Referee</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($match = $matches_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $match['round_number']; ?></td>
                            <td><?php echo htmlspecialchars($match['team1_name']); ?></td>
                            <td><?php echo htmlspecialchars($match['team2_name']); ?></td>
                            <td><?php echo htmlspecialchars($match['referee_name'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $match['status']; ?>">
                                    <?php echo str_replace('_', ' ', ucfirst($match['status'])); ?>
                                </span>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php 
            endif;
        endwhile;
        ?>
    </div>
</body>
</html>
<?php $conn->close(); ?>