<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require_once 'config.php';
$message = '';
$teams_per_pool = 6; 

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['setup_tournament'])) {
    $num_pools = intval($_POST['num_pools']);
    $teams_per_pool = intval($_POST['teams_per_pool']);
    
    $conn = getDBConnection();
    
    $conn->query("DELETE FROM matches");
    $conn->query("DELETE FROM referees");
    $conn->query("DELETE FROM teams");
    $conn->query("DELETE FROM pools");
    
    for ($i = 1; $i <= $num_pools; $i++) {
        $conn->query("INSERT INTO pools (pool_number) VALUES ($i)");
    }
    
    $_SESSION['teams_per_pool'] = $teams_per_pool;
    
    $message = "Tournament structure created! Now add team and referee names.";
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_names'])) {
    $conn = getDBConnection();
    
    if (isset($_POST['team_names'])) {
        foreach ($_POST['team_names'] as $pool_num => $teams) {
            $pool_result = $conn->query("SELECT id FROM pools WHERE pool_number = $pool_num");
            $pool_id = $pool_result->fetch_assoc()['id'];
            
            foreach ($teams as $team_name) {
                if (!empty(trim($team_name))) {
                    $team_name = $conn->real_escape_string(trim($team_name));
                    $conn->query("INSERT INTO teams (name, pool_id) VALUES ('$team_name', $pool_id)");
                }
            }
        }
    }
    
    if (isset($_POST['referee_names'])) {
        foreach ($_POST['referee_names'] as $pool_num => $ref_name) {
            $pool_result = $conn->query("SELECT id FROM pools WHERE pool_number = $pool_num");
            $pool_id = $pool_result->fetch_assoc()['id'];
            
            if (!empty(trim($ref_name))) {
                $ref_name = $conn->real_escape_string(trim($ref_name));
                $conn->query("INSERT INTO referees (name, pool_id) VALUES ('$ref_name', $pool_id)");
            }
        }
    }
    
    $message = "Teams and referees saved successfully!";
}

$conn = getDBConnection();
$pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");

if (isset($_SESSION['teams_per_pool'])) {
    $teams_per_pool = $_SESSION['teams_per_pool'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tournament Setup</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="admin.php">Dashboard</a>
            <a href="admin_setup.php">Tournament Setup</a>
            <a href="admin_matches.php">Generate Matches</a>
            <a href="admin_manage_matches.php">Manage Matches</a>
            <a href="admin_knockout.php">Knockout Setup</a>
            <a href="logout.php">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Tournament Setup</h1>
        
        <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
        <?php endif; ?>
        
        <div class="form-card">
            <h2>Step 1: Create Tournament Structure</h2>
            <form method="POST">
                <div class="form-group">
                    <label>Number of Pools</label>
                    <input type="number" name="num_pools" min="1" max="20" required value="4">
                </div>
                <div class="form-group">
                    <label>Number of Teams per Pool</label>
                    <input type="number" name="teams_per_pool" min="2" max="20" required value="6">
                </div>
                <button type="submit" name="setup_tournament" class="btn btn-primary">Create Structure</button>
            </form>
        </div>
        
        <?php if ($pools_result->num_rows > 0): ?>
        <div class="form-card">
            <h2>Step 2: Add Team and Referee Names</h2>
            <p><strong>Teams per pool:</strong> <?php echo $teams_per_pool; ?> | <strong>Referee per pool:</strong> 1</p>
            <form method="POST">
                <?php 
                $pools_result->data_seek(0);
                while ($pool = $pools_result->fetch_assoc()): 
                    $pool_num = $pool['pool_number'];
                    
                    $teams_query = "SELECT * FROM teams WHERE pool_id = {$pool['id']}";
                    $teams_result = $conn->query($teams_query);
                    $existing_teams = [];
                    while ($team = $teams_result->fetch_assoc()) {
                        $existing_teams[] = $team['name'];
                    }
                    
                    $refs_query = "SELECT * FROM referees WHERE pool_id = {$pool['id']} LIMIT 1";
                    $refs_result = $conn->query($refs_query);
                    $existing_ref = '';
                    if ($ref = $refs_result->fetch_assoc()) {
                        $existing_ref = $ref['name'];
                    }
                ?>
                <div style="margin-bottom: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                    <h3>Pool <?php echo $pool_num; ?></h3>
                    
                    <div style="margin-bottom: 15px;">
                        <strong>Team Names:</strong>
                        <div class="team-input-grid">
                            <?php for ($i = 0; $i < $teams_per_pool; $i++): ?>
                                <input type="text" 
                                       name="team_names[<?php echo $pool_num; ?>][]" 
                                       placeholder="Team <?php echo $i + 1; ?>"
                                       value="<?php echo isset($existing_teams[$i]) ? htmlspecialchars($existing_teams[$i]) : ''; ?>"
                                       style="margin-bottom: 8px; width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">
                            <?php endfor; ?>
                        </div>
                    </div>
                    
                    <div>
                        <strong>Referee Name:</strong>
                        <input type="text" 
                               name="referee_names[<?php echo $pool_num; ?>]" 
                               placeholder="Referee Name (e.g., John Doe)"
                               value="<?php echo htmlspecialchars($existing_ref); ?>"
                               style="width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; margin-top: 5px;">
                        <small style="color: #666; display: block; margin-top: 5px;">
                            Note: This referee will be assigned to manage matches in this pool
                        </small>
                    </div>
                </div>
                <?php endwhile; ?>
                
                <button type="submit" name="save_names" class="btn btn-success">Save All Names</button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
<?php $conn->close(); ?>