let currentMatchId = null;
let currentTeam1Score = 0;
let currentTeam2Score = 0;
let currentStatus = 'not_started';

function openScoreModal(matchId, team1Name, team2Name, team1Score, team2Score, status) {
    currentMatchId = matchId;
    currentTeam1Score = team1Score;
    currentTeam2Score = team2Score;
    currentStatus = status;
    
    document.getElementById('team1Name').textContent = team1Name;
    document.getElementById('team2Name').textContent = team2Name;
    document.getElementById('team1Score').textContent = team1Score;
    document.getElementById('team2Score').textContent = team2Score;
    document.getElementById('scoreModal').style.display = 'block';
    
    updateStatusButtons(status);
}

function closeModal() {
    document.getElementById('scoreModal').style.display = 'none';
}

function changeScore(team, delta) {
    if (team === 1) {
        currentTeam1Score = Math.max(0, currentTeam1Score + delta);
        document.getElementById('team1Score').textContent = currentTeam1Score;
    } else {
        currentTeam2Score = Math.max(0, currentTeam2Score + delta);
        document.getElementById('team2Score').textContent = currentTeam2Score;
    }
}

function updateStatus(status) {
    currentStatus = status;
    updateStatusButtons(status);
}

function updateStatusButtons(status) {
    const buttons = document.querySelectorAll('.status-btn');
    buttons.forEach(btn => {
        btn.classList.remove('status-active');
        btn.style.boxShadow = 'none';
        btn.style.transform = 'scale(1)';
    });
    
    const statusMap = {
        'not_started': 0,
        'in_progress': 1,
        'completed': 2
    };
    
    const selectedBtn = buttons[statusMap[status]];
    if (selectedBtn) {
        selectedBtn.classList.add('status-active');
        selectedBtn.style.boxShadow = '0 0 20px rgba(52, 152, 219, 0.8), 0 0 40px rgba(52, 152, 219, 0.5)';
        selectedBtn.style.transform = 'scale(1.1)';
    }
}

function saveScore() {
    const formData = new FormData();
    formData.append('match_id', currentMatchId);
    formData.append('team1_score', currentTeam1Score);
    formData.append('team2_score', currentTeam2Score);
    formData.append('status', currentStatus);
    
    fetch('update_score.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            closeModal();
            location.reload();
        } else {
            alert('Error updating score: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error: ' + error);
    });
}

document.addEventListener('click', function(event) {
    const modal = document.getElementById('scoreModal');
    if (event.target === modal) {
        closeModal();
    }
});