<?php
session_start();

// Check if referee is logged in
if (!isset($_SESSION['referee_logged_in'])) {
    header("Location: referee_login.php");
    exit();
}

require_once 'config.php';
$conn = getDBConnection();

// Get all pools
$pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Referee Panel</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="referee.php">Round Robin</a>
            <a href="referee_knockout.php">Knockout</a>
            <a href="logout.php" style="float: right;">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Referee Panel - Round Robin</h1>
        <div style="background: #e8f5e9; padding: 15px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #2ecc71;">
            <strong>Note:</strong> Click "Manage" on any match to update scores and status
        </div>
        
        <div class="pool-grid">
            <?php while ($pool = $pools_result->fetch_assoc()): ?>
                <div class="pool-card" onclick="showPool(<?php echo $pool['pool_number']; ?>)">
                    <h3>Pool <?php echo $pool['pool_number']; ?></h3>
                    <?php
                    $pool_id = $pool['id'];
                    $status_query = "SELECT status, COUNT(*) as count 
                                    FROM matches 
                                    WHERE pool_id = $pool_id AND match_type = 'round_robin' 
                                    GROUP BY status";
                    $status_result = $conn->query($status_query);
                    $stats = ['not_started' => 0, 'in_progress' => 0, 'completed' => 0];
                    while ($stat = $status_result->fetch_assoc()) {
                        $stats[$stat['status']] = $stat['count'];
                    }
                    ?>
                    <p style="margin-top: 10px; font-size: 0.9em;">
                        Not Started: <?php echo $stats['not_started']; ?><br>
                        In Progress: <?php echo $stats['in_progress']; ?><br>
                        Completed: <?php echo $stats['completed']; ?>
                    </p>
                </div>
            <?php endwhile; ?>
        </div>
        
        <?php
        $pools_result->data_seek(0);
        $has_any_matches = false;
        
        while ($pool = $pools_result->fetch_assoc()):
            $pool_id = $pool['id'];
            $matches_query = "SELECT m.*, 
                                    t1.name as team1_name, 
                                    t2.name as team2_name, 
                                    r.name as referee_name 
                             FROM matches m 
                             JOIN teams t1 ON m.team1_id = t1.id 
                             JOIN teams t2 ON m.team2_id = t2.id 
                             LEFT JOIN referees r ON m.referee_id = r.id 
                             WHERE m.pool_id = $pool_id AND m.match_type = 'round_robin'
                             ORDER BY m.round_number";
            $matches_result = $conn->query($matches_query);
            
            if ($matches_result->num_rows > 0):
                $has_any_matches = true;
        ?>
        <div id="pool-<?php echo $pool['pool_number']; ?>" class="form-card">
            <h2>Pool <?php echo $pool['pool_number']; ?></h2>
            <div class="match-table">
                <table>
                    <thead>
                        <tr>
                            <th>Round</th>
                            <th>Court</th>
                            <th>Time</th>
                            <th>Team 1</th>
                            <th>Score</th>
                            <th>Team 2</th>
                            <th>Score</th>
                            <th>Referee</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($match = $matches_result->fetch_assoc()): ?>
                        <tr>
                            <td><strong><?php echo $match['round_number']; ?></strong></td>
                            <td><?php echo htmlspecialchars($match['court_name'] ?? 'TBA'); ?></td>
                            <td><?php echo htmlspecialchars($match['start_time'] ?? 'TBA'); ?></td>
                            <td><?php echo htmlspecialchars($match['team1_name']); ?></td>
                            <td><strong><?php echo $match['team1_score']; ?></strong></td>
                            <td><?php echo htmlspecialchars($match['team2_name']); ?></td>
                            <td><strong><?php echo $match['team2_score']; ?></strong></td>
                            <td><?php echo htmlspecialchars($match['referee_name'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $match['status']; ?>">
                                    <?php echo str_replace('_', ' ', ucfirst($match['status'])); ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-primary" style="padding: 5px 10px; font-size: 0.85em;" 
                                        onclick="openScoreModal(<?php echo $match['id']; ?>, 
                                                '<?php echo addslashes($match['team1_name']); ?>', 
                                                '<?php echo addslashes($match['team2_name']); ?>', 
                                                <?php echo $match['team1_score']; ?>, 
                                                <?php echo $match['team2_score']; ?>,
                                                '<?php echo $match['status']; ?>')">
                                    Manage
                                </button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php 
            endif;
        endwhile;
        
        // Show message if no matches exist
        if (!$has_any_matches):
        ?>
        <div class="form-card">
            <h2>No Matches Available</h2>
            <p style="text-align: center; padding: 40px; color: #666;">
                No matches have been generated yet.<br><br>
                Please contact the tournament administrator to generate matches.
            </p>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Score Management Modal -->
    <div id="scoreModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 1000;">
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 10px; min-width: 500px; max-width: 90%;">
            <h2 id="modalTitle">Manage Match Score</h2>
            <div style="margin: 20px 0;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                    <div style="flex: 1; text-align: center;">
                        <h3 id="team1Name"></h3>
                        <div class="score-section" style="justify-content: center; margin-top: 10px;">
                            <button class="score-btn score-down" onclick="changeScore(1, -1)">-</button>
                            <div class="score-display" id="team1Score">0</div>
                            <button class="score-btn score-up" onclick="changeScore(1, 1)">+</button>
                        </div>
                    </div>
                    <div style="font-size: 2em; padding: 0 20px;">VS</div>
                    <div style="flex: 1; text-align: center;">
                        <h3 id="team2Name"></h3>
                        <div class="score-section" style="justify-content: center; margin-top: 10px;">
                            <button class="score-btn score-down" onclick="changeScore(2, -1)">-</button>
                            <div class="score-display" id="team2Score">0</div>
                            <button class="score-btn score-up" onclick="changeScore(2, 1)">+</button>
                        </div>
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <strong>Match Status:</strong>
                    <div style="margin-top: 10px;">
                        <button class="status-btn btn-secondary" onclick="updateStatus('not_started')" type="button">Not Started</button>
                        <button class="status-btn btn-primary" onclick="updateStatus('in_progress')" type="button">In Progress</button>
                        <button class="status-btn btn-success" onclick="updateStatus('completed')" type="button">Completed</button>
                    </div>
                </div>
            </div>
            
            <div style="margin-top: 20px; text-align: center;">
                <button class="btn btn-success" onclick="saveScore()">Save Changes</button>
                <button class="btn btn-secondary" onclick="closeModal()">Cancel</button>
            </div>
        </div>
    </div>
    
    <script src="referee.js"></script>
    <script>
        function showPool(poolNumber) {
            const poolElement = document.getElementById('pool-' + poolNumber);
            if (poolElement) {
                poolElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        }
    </script>
</body>
</html>
<?php $conn->close(); ?>