<?php
session_start();

if (!isset($_SESSION['referee_logged_in'])) {
    header("Location: referee_login.php");
    exit();
}

require_once 'config.php';
$conn = getDBConnection();

$knockout_query = "SELECT m.*, 
                          t1.name as team1_name, 
                          t2.name as team2_name, 
                          r.name as referee_name 
                   FROM matches m 
                   JOIN teams t1 ON m.team1_id = t1.id 
                   JOIN teams t2 ON m.team2_id = t2.id 
                   LEFT JOIN referees r ON m.referee_id = r.id 
                   WHERE m.match_type = 'knockout'
                   ORDER BY m.round_number, m.id";
$knockout_result = $conn->query($knockout_query);

$rounds = [];
while ($match = $knockout_result->fetch_assoc()) {
    $rounds[$match['round_number']][] = $match;
}

function getRoundName($round_num, $total_rounds) {
    if ($round_num == $total_rounds) return "Finals";
    if ($round_num == $total_rounds - 1) return "Semi-Finals";
    if ($round_num == $total_rounds - 2) return "Quarter-Finals";

    $teams_in_round = pow(2, $total_rounds - $round_num + 1);
    return "Round of " . $teams_in_round;
}

$total_rounds = 0;
if (!empty($rounds)) {
    $first_round_matches = reset($rounds);
    $teams_in_first_round = count($first_round_matches) * 2;
    $total_rounds = log($teams_in_first_round, 2);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Referee - Knockout</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .bracket-container {
            display: flex;
            gap: 40px;
            overflow-x: auto;
            padding: 20px;
            background: white;
            border-radius: 10px;
        }
        
        .bracket-round {
            display: flex;
            flex-direction: column;
            justify-content: space-around;
            min-width: 250px;
        }
        
        .bracket-round h3 {
            text-align: center;
            margin-bottom: 20px;
            color: #2c3e50;
            font-size: 1.2em;
            border-bottom: 3px solid #3498db;
            padding-bottom: 10px;
        }
        
        .bracket-match {
            background: #f8f9fa;
            border: 2px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            margin: 10px 0;
            transition: all 0.3s;
            cursor: pointer;
        }
        
        .bracket-match:hover {
            transform: translateX(5px);
            box-shadow: 0 3px 10px rgba(0,0,0,0.2);
            border-color: #3498db;
        }
        
        .bracket-match.completed {
            border-color: #2ecc71;
            background: #e8f8f5;
        }
        
        .bracket-match.in_progress {
            border-color: #f39c12;
            background: #fef9e7;
        }
        
        .bracket-team {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px;
            margin: 5px 0;
            background: white;
            border-radius: 5px;
            border-left: 4px solid #ddd;
        }
        
        .bracket-team.winner {
            border-left-color: #2ecc71;
            background: #d4edda;
            font-weight: bold;
        }
        
        .bracket-team-name {
            flex: 1;
            font-size: 1em;
        }
        
        .bracket-score {
            font-size: 1.3em;
            font-weight: bold;
            margin-left: 10px;
            min-width: 30px;
            text-align: center;
        }
        
        .bracket-vs {
            text-align: center;
            color: #95a5a6;
            font-weight: bold;
            margin: 5px 0;
        }
        
        .bracket-info {
            text-align: center;
            font-size: 0.85em;
            color: #7f8c8d;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 1px solid #ecf0f1;
        }
        
        .manage-btn {
            width: 100%;
            margin-top: 10px;
            padding: 8px;
            background: #3498db;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.9em;
        }
        
        .manage-btn:hover {
            background: #2980b9;
        }
    </style>
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="referee.php">Round Robin</a>
            <a href="referee_knockout.php">Knockout</a>
            <a href="logout.php" style="float: right;">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Referee Panel - Knockout Stage</h1>
        <div style="background: #e8f5e9; padding: 15px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #2ecc71;">
            <strong>Note:</strong> Click on any match to update scores and status
        </div>
        
        <?php if (count($rounds) > 0): ?>
        <div class="form-card">
            <div class="bracket-container">
                <?php 
                ksort($rounds);
                foreach ($rounds as $round_num => $matches): 
                    $round_name = getRoundName($round_num, $total_rounds);
                ?>
                <div class="bracket-round">
                    <h3><?php echo $round_name; ?></h3>
                    <?php foreach ($matches as $match): 
                        $team1_won = ($match['status'] == 'completed' && $match['team1_score'] > $match['team2_score']);
                        $team2_won = ($match['status'] == 'completed' && $match['team2_score'] > $match['team1_score']);
                    ?>
                    <div class="bracket-match <?php echo $match['status']; ?>" 
                         onclick="openScoreModal(<?php echo $match['id']; ?>, 
                                 '<?php echo addslashes($match['team1_name']); ?>', 
                                 '<?php echo addslashes($match['team2_name']); ?>', 
                                 <?php echo $match['team1_score']; ?>, 
                                 <?php echo $match['team2_score']; ?>,
                                 '<?php echo $match['status']; ?>')">
                        <div class="bracket-team <?php echo $team1_won ? 'winner' : ''; ?>">
                            <span class="bracket-team-name"><?php echo htmlspecialchars($match['team1_name']); ?></span>
                            <span class="bracket-score"><?php echo $match['team1_score']; ?></span>
                        </div>
                        <div class="bracket-vs">VS</div>
                        <div class="bracket-team <?php echo $team2_won ? 'winner' : ''; ?>">
                            <span class="bracket-team-name"><?php echo htmlspecialchars($match['team2_name']); ?></span>
                            <span class="bracket-score"><?php echo $match['team2_score']; ?></span>
                        </div>
                        <div class="bracket-info">
                            <?php if ($match['court_name']): ?>
                                Court: <?php echo htmlspecialchars($match['court_name']); ?><br>
                            <?php endif; ?>
                            <?php if ($match['start_time']): ?>
                                Time: <?php echo htmlspecialchars($match['start_time']); ?><br>
                            <?php endif; ?>
                            <?php if ($match['referee_name']): ?>
                                Ref: <?php echo htmlspecialchars($match['referee_name']); ?><br>
                            <?php endif; ?>
                            <span class="status-badge status-<?php echo $match['status']; ?>">
                                <?php echo str_replace('_', ' ', ucfirst($match['status'])); ?>
                            </span>
                        </div>
                        <button class="manage-btn" onclick="event.stopPropagation(); openScoreModal(<?php echo $match['id']; ?>, 
                                '<?php echo addslashes($match['team1_name']); ?>', 
                                '<?php echo addslashes($match['team2_name']); ?>', 
                                <?php echo $match['team1_score']; ?>, 
                                <?php echo $match['team2_score']; ?>,
                                '<?php echo $match['status']; ?>')">
                            Manage Match
                        </button>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php else: ?>
        <div class="form-card">
            <h2>No Knockout Matches Yet</h2>
            <p style="text-align: center; padding: 40px; color: #666;">
                Knockout matches need to be created by the admin.
            </p>
        </div>
        <?php endif; ?>
    </div>
    
    <div id="scoreModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 1000;">
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 10px; min-width: 500px; max-width: 90%;">
            <h2 id="modalTitle">Manage Match Score</h2>
            <div style="margin: 20px 0;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                    <div style="flex: 1; text-align: center;">
                        <h3 id="team1Name"></h3>
                        <div class="score-section" style="justify-content: center; margin-top: 10px;">
                            <button class="score-btn score-down" onclick="changeScore(1, -1)">-</button>
                            <div class="score-display" id="team1Score">0</div>
                            <button class="score-btn score-up" onclick="changeScore(1, 1)">+</button>
                        </div>
                    </div>
                    <div style="font-size: 2em; padding: 0 20px;">VS</div>
                    <div style="flex: 1; text-align: center;">
                        <h3 id="team2Name"></h3>
                        <div class="score-section" style="justify-content: center; margin-top: 10px;">
                            <button class="score-btn score-down" onclick="changeScore(2, -1)">-</button>
                            <div class="score-display" id="team2Score">0</div>
                            <button class="score-btn score-up" onclick="changeScore(2, 1)">+</button>
                        </div>
                    </div>
                </div>
                
                <div style="margin-top: 30px;">
                    <strong>Match Status:</strong>
                    <div style="margin-top: 10px;">
                        <button class="status-btn btn-secondary" onclick="updateStatus('not_started')" type="button">Not Started</button>
                        <button class="status-btn btn-primary" onclick="updateStatus('in_progress')" type="button">In Progress</button>
                        <button class="status-btn btn-success" onclick="updateStatus('completed')" type="button">Completed</button>
                    </div>
                </div>
            </div>
            
            <div style="margin-top: 20px; text-align: center;">
                <button class="btn btn-success" onclick="saveScore()">Save Changes</button>
                <button class="btn btn-secondary" onclick="closeModal()">Cancel</button>
            </div>
        </div>
    </div>
    
    <script src="referee.js"></script>
</body>
</html>
<?php $conn->close(); ?>