<?php
header('Content-Type: application/json');
require_once 'config.php';

$team_name = isset($_GET['team']) ? trim($_GET['team']) : '';

if (empty($team_name)) {
    echo json_encode(['found' => false]);
    exit();
}

$conn = getDBConnection();

$search_term = '%' . $conn->real_escape_string($team_name) . '%';
$query = "SELECT t.*, p.pool_number 
          FROM teams t 
          JOIN pools p ON t.pool_id = p.id 
          WHERE t.name LIKE '$search_term' 
          LIMIT 1";

$result = $conn->query($query);

if ($result->num_rows > 0) {
    $team = $result->fetch_assoc();
    echo json_encode([
        'found' => true,
        'pool_number' => $team['pool_number'],
        'team_name' => $team['name']
    ]);
} else {
    echo json_encode(['found' => false]);
}

$conn->close();
?>