<?php
require_once 'config.php';
$conn = getDBConnection();

$current_pool = isset($_GET['pool']) ? intval($_GET['pool']) : 1;

$pools_result = $conn->query("SELECT * FROM pools ORDER BY pool_number");
$pools = [];
while ($pool = $pools_result->fetch_assoc()) {
    $pools[] = $pool;
}

$pool_exists = false;
foreach ($pools as $pool) {
    if ($pool['pool_number'] == $current_pool) {
        $pool_exists = true;
        break;
    }
}
if (!$pool_exists && count($pools) > 0) {
    $current_pool = $pools[0]['pool_number'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Spectator View</title>
    <link rel="stylesheet" href="style.css">
    <script>
        let autoRefreshTimeout;
        
        function startAutoRefresh() {
            const urlParams = new URLSearchParams(window.location.search);
            const highlight = urlParams.get('highlight');
            
            if (!highlight) {
                autoRefreshTimeout = setTimeout(function() {
                    location.reload();
                }, 5000);
            }
        }
        
        startAutoRefresh();
        
        function showPool(poolNum) {
            window.location.href = 'spectator.php?pool=' + poolNum;
        }
        
        function searchTeam() {
            const searchTerm = document.getElementById('teamSearch').value.toLowerCase().trim();
            if (!searchTerm) {
                alert('Please enter a team name to search');
                return;
            }
            
            fetch('search_team.php?team=' + encodeURIComponent(searchTerm))
                .then(response => response.json())
                .then(data => {
                    if (data.found) {
                        window.location.href = 'spectator.php?pool=' + data.pool_number + '&highlight=' + encodeURIComponent(searchTerm);
                    } else {
                        alert('Team "' + searchTerm + '" not found in any pool');
                    }
                })
                .catch(error => {
                    console.error('Search error:', error);
                    alert('Error searching for team');
                });
        }
        
        function clearSearch() {
            const urlParams = new URLSearchParams(window.location.search);
            const pool = urlParams.get('pool') || <?php echo $current_pool; ?>;
            window.location.href = 'spectator.php?pool=' + pool;
        }
        
        window.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const highlight = urlParams.get('highlight');
            
            if (highlight) {
                const clearBtn = document.getElementById('clearSearchBtn');
                if (clearBtn) clearBtn.style.display = 'inline-block';
                
                const rows = document.querySelectorAll('.match-table tbody tr');
                let found = false;
                
                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    cells.forEach(cell => {
                        if (cell.textContent.toLowerCase().includes(highlight.toLowerCase())) {
                            row.style.background = '#fff3cd';
                            row.style.transition = 'background 0.3s';
                            if (!found) {
                                row.scrollIntoView({ behavior: 'smooth', block: 'center' });
                                found = true;
                            }
                        }
                    });
                });
            }
        });
    </script>
</head>
<body>
    <div class="nav-bar">
        <div class="container">
            <a href="index.php">Home</a>
            <a href="spectator.php">Round Robin</a>
            <a href="spectator_knockout.php">Knockout</a>
        </div>
    </div>
    
    <div class="container">
        <h1>Live Scoreboard - Round Robin</h1>
        <div class="auto-refresh" id="autoRefreshMsg">
            <?php 
            $highlight = isset($_GET['highlight']) ? $_GET['highlight'] : '';
            if ($highlight) {
                echo '<span style="color: #f39c12;">Auto-refresh paused during search - Click "Clear" to resume</span>';
            } else {
                echo 'Auto-refreshing every 5 seconds...';
            }
            ?>
        </div>
        
        <div class="form-card" style="padding: 15px;">
            <div style="display: flex; gap: 10px; align-items: center;">
                <input type="text" id="teamSearch" placeholder="Search team name..." 
                       style="flex: 1; padding: 10px; border: 1px solid #ddd; border-radius: 5px;"
                       onkeypress="if(event.key === 'Enter') searchTeam()">
                <button onclick="searchTeam()" class="btn btn-primary" style="padding: 10px 20px; min-width: auto;">Search</button>
                <button id="clearSearchBtn" onclick="clearSearch()" class="btn btn-secondary" style="padding: 10px 20px; min-width: auto; display: none;">Clear</button>
            </div>
        </div>
        
        <?php if (count($pools) > 0): ?>
        <div class="pool-tabs">
            <?php foreach ($pools as $pool): 
                $pool_id = $pool['id'];
                $status_query = "SELECT status, COUNT(*) as count 
                                FROM matches 
                                WHERE pool_id = $pool_id AND match_type = 'round_robin' 
                                GROUP BY status";
                $status_result = $conn->query($status_query);
                $stats = ['not_started' => 0, 'in_progress' => 0, 'completed' => 0];
                while ($stat = $status_result->fetch_assoc()) {
                    $stats[$stat['status']] = $stat['count'];
                }
            ?>
            <div id="pool-tab-<?php echo $pool['pool_number']; ?>" 
                 class="pool-tab <?php echo $pool['pool_number'] == $current_pool ? 'active' : ''; ?>" 
                 onclick="showPool(<?php echo $pool['pool_number']; ?>)">
                <strong>Pool <?php echo $pool['pool_number']; ?></strong>
                <div style="font-size: 0.85em; margin-top: 5px;">
                    <div>Completed: <?php echo $stats['completed']; ?></div>
                    <div>In Progress: <?php echo $stats['in_progress']; ?></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <?php
        foreach ($pools as $pool):
            if ($pool['pool_number'] != $current_pool) continue;
            
            $pool_id = $pool['id'];
            $pool_number = $pool['pool_number'];
            
            $matches_query = "SELECT m.*, 
                                    t1.name as team1_name, 
                                    t2.name as team2_name, 
                                    r.name as referee_name 
                             FROM matches m 
                             JOIN teams t1 ON m.team1_id = t1.id 
                             JOIN teams t2 ON m.team2_id = t2.id 
                             LEFT JOIN referees r ON m.referee_id = r.id 
                             WHERE m.pool_id = $pool_id AND m.match_type = 'round_robin'
                             ORDER BY m.round_number";
            $matches_result = $conn->query($matches_query);
            
            $has_matches = $matches_result->num_rows > 0;
        ?>
        <div id="pool-content-<?php echo $pool_number; ?>" class="pool-content active">
            <div class="form-card">
                <h2>Pool <?php echo $pool_number; ?> - Matches</h2>
                <?php if ($has_matches): ?>
                <div class="match-table">
                    <table>
                        <thead>
                            <tr>
                                <th>Round</th>
                                <th>Court</th>
                                <th>Time</th>
                                <th>Team 1</th>
                                <th>Score</th>
                                <th>Team 2</th>
                                <th>Score</th>
                                <th>Referee</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($match = $matches_result->fetch_assoc()): ?>
                            <tr>
                                <td><strong><?php echo $match['round_number']; ?></strong></td>
                                <td><?php echo htmlspecialchars($match['court_name'] ?? 'TBA'); ?></td>
                                <td><?php echo htmlspecialchars($match['start_time'] ?? 'TBA'); ?></td>
                                <td><?php echo htmlspecialchars($match['team1_name']); ?></td>
                                <td><strong><?php echo $match['team1_score']; ?></strong></td>
                                <td><?php echo htmlspecialchars($match['team2_name']); ?></td>
                                <td><strong><?php echo $match['team2_score']; ?></strong></td>
                                <td><?php echo htmlspecialchars($match['referee_name'] ?? 'N/A'); ?></td>
                                <td>
                                    <span class="status-badge status-<?php echo $match['status']; ?>">
                                        <?php echo str_replace('_', ' ', ucfirst($match['status'])); ?>
                                    </span>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php
                $teams_query = "SELECT * FROM teams WHERE pool_id = $pool_id";
                $teams_result = $conn->query($teams_query);
                $standings = [];
                
                while ($team = $teams_result->fetch_assoc()) {
                    $team_id = $team['id'];
                    $team_name = $team['name'];
                    
                    $stats_query = "SELECT 
                        SUM(CASE WHEN team1_id = $team_id AND team1_score > team2_score AND status = 'completed' THEN 1
                                 WHEN team2_id = $team_id AND team2_score > team1_score AND status = 'completed' THEN 1
                                 ELSE 0 END) as wins,
                        SUM(CASE WHEN team1_id = $team_id AND team1_score < team2_score AND status = 'completed' THEN 1
                                 WHEN team2_id = $team_id AND team2_score < team1_score AND status = 'completed' THEN 1
                                 ELSE 0 END) as losses,
                        SUM(CASE WHEN team1_id = $team_id THEN team1_score ELSE 0 END) as points_for,
                        SUM(CASE WHEN team1_id = $team_id THEN team2_score ELSE 0 END) as points_against_as_team1,
                        SUM(CASE WHEN team2_id = $team_id THEN team2_score ELSE 0 END) as points_for2,
                        SUM(CASE WHEN team2_id = $team_id THEN team1_score ELSE 0 END) as points_against_as_team2
                    FROM matches 
                    WHERE (team1_id = $team_id OR team2_id = $team_id) 
                    AND pool_id = $pool_id 
                    AND match_type = 'round_robin'";
                    
                    $stats_result = $conn->query($stats_query);
                    $stats = $stats_result->fetch_assoc();
                    
                    $wins = $stats['wins'] ?? 0;
                    $losses = $stats['losses'] ?? 0;
                    $points_for = ($stats['points_for'] ?? 0) + ($stats['points_for2'] ?? 0);
                    $points_against = ($stats['points_against_as_team1'] ?? 0) + ($stats['points_against_as_team2'] ?? 0);
                    $point_diff = $points_for - $points_against;
                    
                    $standings[] = [
                        'team_id' => $team_id,
                        'team_name' => $team_name,
                        'wins' => $wins,
                        'losses' => $losses,
                        'points_for' => $points_for,
                        'points_against' => $points_against,
                        'point_diff' => $point_diff
                    ];
                }
                
                usort($standings, function($a, $b) {
                    if ($a['wins'] != $b['wins']) {
                        return $b['wins'] - $a['wins'];
                    }
                    return $b['point_diff'] - $a['point_diff'];
                });
                ?>
                
                <h3 style="margin-top: 20px;">Standings</h3>
                <div class="match-table">
                    <table>
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Team</th>
                                <th>Wins</th>
                                <th>Losses</th>
                                <th>Total Score</th>
                                <th>Total Against</th>
                                <th>Score Diff</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $rank = 1;
                            foreach ($standings as $standing): 
                                $rowClass = ($rank <= 0) ? 'style="background: #d4edda;"' : '';
                            ?>
                            <tr <?php echo $rowClass; ?>>
                                <td><strong><?php echo $rank; ?></strong></td>
                                <td>
                                    <?php echo htmlspecialchars($standing['team_name']); ?>
                                </td>
                                <td><?php echo $standing['wins']; ?></td>
                                <td><?php echo $standing['losses']; ?></td>
                                <td><?php echo $standing['points_for']; ?></td>
                                <td><?php echo $standing['points_against']; ?></td>
                                <td style="font-weight: bold; <?php echo $standing['point_diff'] >= 0 ? 'color: green;' : 'color: red;'; ?>">
                                    <?php echo $standing['point_diff'] >= 0 ? '+' : ''; ?><?php echo $standing['point_diff']; ?>
                                </td>
                            </tr>
                            <?php 
                            $rank++;
                            endforeach; 
                            ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <p style="text-align: center; padding: 40px; color: #666;">
                    No matches have been generated for this pool yet.
                </p>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
        
        <?php else: ?>
        <div class="form-card">
            <h2>No Pools Available</h2>
            <p style="text-align: center; padding: 40px; color: #666;">
                No tournament has been set up yet.
            </p>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
<?php $conn->close(); ?>