<?php
header('Content-Type: application/json');
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $match_id = intval($_POST['match_id']);
    $team1_score = intval($_POST['team1_score']);
    $team2_score = intval($_POST['team2_score']);
    $status = $_POST['status'];
    
    $valid_statuses = ['not_started', 'in_progress', 'completed'];
    if (!in_array($status, $valid_statuses)) {
        echo json_encode(['success' => false, 'message' => 'Invalid status']);
        exit();
    }
    
    $conn = getDBConnection();
    
    $stmt = $conn->prepare("UPDATE matches SET team1_score = ?, team2_score = ?, status = ? WHERE id = ?");
    $stmt->bind_param("iisi", $team1_score, $team2_score, $status, $match_id);
    
    if ($stmt->execute()) {
        $match_check = $conn->query("SELECT * FROM matches WHERE id = $match_id AND match_type = 'knockout'");
        
        if ($match_check->num_rows > 0 && $status == 'completed') {
            $match_data = $match_check->fetch_assoc();
            $current_round = $match_data['round_number'];
            
            $incomplete_query = "SELECT COUNT(*) as count FROM matches 
                                WHERE match_type = 'knockout' 
                                AND round_number = $current_round 
                                AND status != 'completed'";
            $incomplete_result = $conn->query($incomplete_query);
            $incomplete_count = $incomplete_result->fetch_assoc()['count'];
            
            if ($incomplete_count == 0) {
                $winners_query = "SELECT m.id, m.team1_id, m.team2_id, m.team1_score, m.team2_score
                                 FROM matches m
                                 WHERE m.match_type = 'knockout' 
                                 AND m.round_number = $current_round 
                                 AND m.status = 'completed'
                                 ORDER BY m.id";
                
                $winners_result = $conn->query($winners_query);
                $winners = [];
                
                while ($match = $winners_result->fetch_assoc()) {
                    if ($match['team1_score'] > $match['team2_score']) {
                        $winners[] = $match['team1_id'];
                    } elseif ($match['team2_score'] > $match['team1_score']) {
                        $winners[] = $match['team2_id'];
                    }
                }
                
                if (count($winners) >= 2) {
                    $next_round = $current_round + 1;
                    
                    for ($i = 0; $i < count($winners); $i += 2) {
                        if (isset($winners[$i + 1])) {
                            $team1_id = $winners[$i];
                            $team2_id = $winners[$i + 1];
                            
                            $insert_stmt = $conn->prepare("INSERT INTO matches (pool_id, round_number, team1_id, team2_id, match_type, status) VALUES (1, ?, ?, ?, 'knockout', 'not_started')");
                            $insert_stmt->bind_param("iii", $next_round, $team1_id, $team2_id);
                            $insert_stmt->execute();
                            $insert_stmt->close();
                        }
                    }
                }
            }
        }
        
        echo json_encode(['success' => true, 'message' => 'Score updated successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
    }
    
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>